<?LassoScript

	// This include creates the navigation interface for the right side of the site.
	// Note that when the administration interface is being shown 'nav_edit.lasso' is used
	// instead.

	// Find all of the valid sections in the site
	inline: -log=$log_level,
			-search,
			-database='op_collaborate',
			-table='sections',
			-keyfield='id',
			-op='eq', 'status' = 'Y',
			-maxrecords='all',
			-sortfield='sort',
			-returnfield='code', -returnfield='title', -returnfield='id';
		records;
			var: 'nav_section_code' = (field: 'code');
			
			// If the section is selected then display using the selected style
			if: ((var: 'section') == (field: 'code'));
				'<div class="nav_one_selected"><a href="index.lasso?section=' + (var: 'nav_section_code', -EncodeStrictURL) + '">' + (field: 'title', -EncodeHTML) + '</a> &gt;</div>\r\n';
			else;
				'<div class="nav_one"><a href="index.lasso?section=' + (var: 'nav_section_code') + '">' + (field: 'title', -EncodeHTML) + '</a></div>\r\n';
			/if;
			
			// If the section is selected then display the pages within the section
			if: ((var: 'section') == (field: 'code'));
			
				// Find all of the valid pages within the section
				inline: -log=$log_level,
						-search,
						-database='op_collaborate',
						-table='pages',
						-keyfield='id',
						-op='eq', 'section_id' = (field: 'id'),
						-op='eq', 'status' = 'Y',
						-maxrecords='all',
						-sortfield='sort',
						-returnfield='code', -returnfield='title';
					records;
					
						// If the page is selected then display using the selected style
						if: ((var: 'page') == (field: 'code'));
							'<div class="nav_two_selected"><a href="index.lasso?section=' + (var: 'nav_section_code', -EncodeStrictURL) + '&amp;page=' (field: 'code', -EncodeStrictURL) + '">' + (field: 'title', -EncodeHTML) + '</a> &gt;</div>\r\n';
						else;
							'<div class="nav_two"><a href="index.lasso?section=' + (var: 'nav_section_code', -EncodeStrictURL) + '&amp;page=' + (field: 'code', -EncodeStrictURL) + '">' + (field: 'title', -EncodeHTML) + '</a></div>\r\n';
						/if;
					/records;
				/inline;
			/if;
		/records;
	/inline;
?>